/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theanomaly.network;

import java.util.function.Supplier;
import net.mcreator.theanomaly.TheAnomalyMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TheAnomalyModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TheAnomalyMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        TheAnomalyMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.BlindnessJumpscareActive = message.data.BlindnessJumpscareActive;
                    variables.CanBlindnessJumpscareBeActivated = message.data.CanBlindnessJumpscareBeActivated;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean BlindnessJumpscareActive = false;
        public boolean CanBlindnessJumpscareBeActivated = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                TheAnomalyMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("BlindnessJumpscareActive", this.BlindnessJumpscareActive);
            nbt.m_128379_("CanBlindnessJumpscareBeActivated", this.CanBlindnessJumpscareBeActivated);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.BlindnessJumpscareActive = nbt.m_128471_("BlindnessJumpscareActive");
            this.CanBlindnessJumpscareBeActivated = nbt.m_128471_("CanBlindnessJumpscareBeActivated");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("the_anomaly", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "the_anomaly_mapvars";
        public double Warning = 0.0;
        public double AnxietyDurationMultiplier = 1.0;
        public boolean AnomalyViewerSpawn = true;
        public boolean AnomalyDeceitfulSpawn = true;
        public boolean AnxietyEnabled = true;
        public boolean CrashEnabled = true;
        public boolean FirstConfigEnabled = false;
        public double Anger = 0.0;
        public boolean AngerSystemUpdated = false;
        public boolean customweather = false;
        public boolean customweathersfx = false;
        public boolean customclouds = false;
        public boolean customsky = false;
        public boolean custommoon = false;
        public boolean SkyboxSetup = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.Warning = nbt.m_128459_("Warning");
            this.AnxietyDurationMultiplier = nbt.m_128459_("AnxietyDurationMultiplier");
            this.AnomalyViewerSpawn = nbt.m_128471_("AnomalyViewerSpawn");
            this.AnomalyDeceitfulSpawn = nbt.m_128471_("AnomalyDeceitfulSpawn");
            this.AnxietyEnabled = nbt.m_128471_("AnxietyEnabled");
            this.CrashEnabled = nbt.m_128471_("CrashEnabled");
            this.FirstConfigEnabled = nbt.m_128471_("FirstConfigEnabled");
            this.Anger = nbt.m_128459_("Anger");
            this.AngerSystemUpdated = nbt.m_128471_("AngerSystemUpdated");
            this.customweather = nbt.m_128471_("customweather");
            this.customweathersfx = nbt.m_128471_("customweathersfx");
            this.customclouds = nbt.m_128471_("customclouds");
            this.customsky = nbt.m_128471_("customsky");
            this.custommoon = nbt.m_128471_("custommoon");
            this.SkyboxSetup = nbt.m_128471_("SkyboxSetup");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("Warning", this.Warning);
            nbt.m_128347_("AnxietyDurationMultiplier", this.AnxietyDurationMultiplier);
            nbt.m_128379_("AnomalyViewerSpawn", this.AnomalyViewerSpawn);
            nbt.m_128379_("AnomalyDeceitfulSpawn", this.AnomalyDeceitfulSpawn);
            nbt.m_128379_("AnxietyEnabled", this.AnxietyEnabled);
            nbt.m_128379_("CrashEnabled", this.CrashEnabled);
            nbt.m_128379_("FirstConfigEnabled", this.FirstConfigEnabled);
            nbt.m_128347_("Anger", this.Anger);
            nbt.m_128379_("AngerSystemUpdated", this.AngerSystemUpdated);
            nbt.m_128379_("customweather", this.customweather);
            nbt.m_128379_("customweathersfx", this.customweathersfx);
            nbt.m_128379_("customclouds", this.customclouds);
            nbt.m_128379_("customsky", this.customsky);
            nbt.m_128379_("custommoon", this.custommoon);
            nbt.m_128379_("SkyboxSetup", this.SkyboxSetup);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                TheAnomalyMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "the_anomaly_worldvars";
        public boolean CheckPlayerLook = false;
        public boolean IsAnomalyBeingWatchedFar = false;
        public boolean IsAnomalyBeingWatchedMedium = false;
        public boolean IsAnomalyBeingWatchedNear = false;
        public boolean IsAnomalyBeingWatchedVeryNear = false;
        public boolean AnomalyFirstSpotted = false;
        public boolean FirstAnomalySpawned = false;
        public boolean AnomalyIsEscaping = false;
        public boolean CanAnomalyUncrawl = false;
        public boolean AnomalyUncrawlUnlocked = false;
        public double PlayerSpawnX = 0.0;
        public double PlayerSpawnY = 0.0;
        public double PlayerSpawnZ = 0.0;
        public boolean AnomalyIsLookingAtPlayer = false;
        public boolean RespawnAnomaly = false;
        public boolean CanChangePhase = true;
        public double MoonPhase = 0.0;
        public double Phase = 0.0;
        public double FogPhase = 0.0;
        public double PlayersSleeping = 0.0;
        public boolean StartHaunt = false;
        public boolean CanShadowAnomalyWalk = false;
        public boolean HasAnomalyAttackSpawned = false;
        public double AnomalyStrenghtBoost = 0.0;
        public double AnomalyHealth = 300.0;
        public double WhenAnomalyDefeated = 0.0;
        public double AnomalyRetreatTime = 0.0;
        public boolean IsAnomalyOnRetreat = false;
        public boolean Deathmode = false;
        public boolean AnomalyViewerIsAttacking = false;
        public double AnomalyDeceitfulCount = 0.0;
        public boolean BookEvent = false;
        public boolean AnomalyViewerCanGrab = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.CheckPlayerLook = nbt.m_128471_("CheckPlayerLook");
            this.IsAnomalyBeingWatchedFar = nbt.m_128471_("IsAnomalyBeingWatchedFar");
            this.IsAnomalyBeingWatchedMedium = nbt.m_128471_("IsAnomalyBeingWatchedMedium");
            this.IsAnomalyBeingWatchedNear = nbt.m_128471_("IsAnomalyBeingWatchedNear");
            this.IsAnomalyBeingWatchedVeryNear = nbt.m_128471_("IsAnomalyBeingWatchedVeryNear");
            this.AnomalyFirstSpotted = nbt.m_128471_("AnomalyFirstSpotted");
            this.FirstAnomalySpawned = nbt.m_128471_("FirstAnomalySpawned");
            this.AnomalyIsEscaping = nbt.m_128471_("AnomalyIsEscaping");
            this.CanAnomalyUncrawl = nbt.m_128471_("CanAnomalyUncrawl");
            this.AnomalyUncrawlUnlocked = nbt.m_128471_("AnomalyUncrawlUnlocked");
            this.PlayerSpawnX = nbt.m_128459_("PlayerSpawnX");
            this.PlayerSpawnY = nbt.m_128459_("PlayerSpawnY");
            this.PlayerSpawnZ = nbt.m_128459_("PlayerSpawnZ");
            this.AnomalyIsLookingAtPlayer = nbt.m_128471_("AnomalyIsLookingAtPlayer");
            this.RespawnAnomaly = nbt.m_128471_("RespawnAnomaly");
            this.CanChangePhase = nbt.m_128471_("CanChangePhase");
            this.MoonPhase = nbt.m_128459_("MoonPhase");
            this.Phase = nbt.m_128459_("Phase");
            this.FogPhase = nbt.m_128459_("FogPhase");
            this.PlayersSleeping = nbt.m_128459_("PlayersSleeping");
            this.StartHaunt = nbt.m_128471_("StartHaunt");
            this.CanShadowAnomalyWalk = nbt.m_128471_("CanShadowAnomalyWalk");
            this.HasAnomalyAttackSpawned = nbt.m_128471_("HasAnomalyAttackSpawned");
            this.AnomalyStrenghtBoost = nbt.m_128459_("AnomalyStrenghtBoost");
            this.AnomalyHealth = nbt.m_128459_("AnomalyHealth");
            this.WhenAnomalyDefeated = nbt.m_128459_("WhenAnomalyDefeated");
            this.AnomalyRetreatTime = nbt.m_128459_("AnomalyRetreatTime");
            this.IsAnomalyOnRetreat = nbt.m_128471_("IsAnomalyOnRetreat");
            this.Deathmode = nbt.m_128471_("Deathmode");
            this.AnomalyViewerIsAttacking = nbt.m_128471_("AnomalyViewerIsAttacking");
            this.AnomalyDeceitfulCount = nbt.m_128459_("AnomalyDeceitfulCount");
            this.BookEvent = nbt.m_128471_("BookEvent");
            this.AnomalyViewerCanGrab = nbt.m_128471_("AnomalyViewerCanGrab");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("CheckPlayerLook", this.CheckPlayerLook);
            nbt.m_128379_("IsAnomalyBeingWatchedFar", this.IsAnomalyBeingWatchedFar);
            nbt.m_128379_("IsAnomalyBeingWatchedMedium", this.IsAnomalyBeingWatchedMedium);
            nbt.m_128379_("IsAnomalyBeingWatchedNear", this.IsAnomalyBeingWatchedNear);
            nbt.m_128379_("IsAnomalyBeingWatchedVeryNear", this.IsAnomalyBeingWatchedVeryNear);
            nbt.m_128379_("AnomalyFirstSpotted", this.AnomalyFirstSpotted);
            nbt.m_128379_("FirstAnomalySpawned", this.FirstAnomalySpawned);
            nbt.m_128379_("AnomalyIsEscaping", this.AnomalyIsEscaping);
            nbt.m_128379_("CanAnomalyUncrawl", this.CanAnomalyUncrawl);
            nbt.m_128379_("AnomalyUncrawlUnlocked", this.AnomalyUncrawlUnlocked);
            nbt.m_128347_("PlayerSpawnX", this.PlayerSpawnX);
            nbt.m_128347_("PlayerSpawnY", this.PlayerSpawnY);
            nbt.m_128347_("PlayerSpawnZ", this.PlayerSpawnZ);
            nbt.m_128379_("AnomalyIsLookingAtPlayer", this.AnomalyIsLookingAtPlayer);
            nbt.m_128379_("RespawnAnomaly", this.RespawnAnomaly);
            nbt.m_128379_("CanChangePhase", this.CanChangePhase);
            nbt.m_128347_("MoonPhase", this.MoonPhase);
            nbt.m_128347_("Phase", this.Phase);
            nbt.m_128347_("FogPhase", this.FogPhase);
            nbt.m_128347_("PlayersSleeping", this.PlayersSleeping);
            nbt.m_128379_("StartHaunt", this.StartHaunt);
            nbt.m_128379_("CanShadowAnomalyWalk", this.CanShadowAnomalyWalk);
            nbt.m_128379_("HasAnomalyAttackSpawned", this.HasAnomalyAttackSpawned);
            nbt.m_128347_("AnomalyStrenghtBoost", this.AnomalyStrenghtBoost);
            nbt.m_128347_("AnomalyHealth", this.AnomalyHealth);
            nbt.m_128347_("WhenAnomalyDefeated", this.WhenAnomalyDefeated);
            nbt.m_128347_("AnomalyRetreatTime", this.AnomalyRetreatTime);
            nbt.m_128379_("IsAnomalyOnRetreat", this.IsAnomalyOnRetreat);
            nbt.m_128379_("Deathmode", this.Deathmode);
            nbt.m_128379_("AnomalyViewerIsAttacking", this.AnomalyViewerIsAttacking);
            nbt.m_128347_("AnomalyDeceitfulCount", this.AnomalyDeceitfulCount);
            nbt.m_128379_("BookEvent", this.BookEvent);
            nbt.m_128379_("AnomalyViewerCanGrab", this.AnomalyViewerCanGrab);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                TheAnomalyMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.BlindnessJumpscareActive = original.BlindnessJumpscareActive;
            clone.CanBlindnessJumpscareBeActivated = original.CanBlindnessJumpscareBeActivated;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_);
                if (mapdata != null) {
                    TheAnomalyMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    TheAnomalyMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_)) != null) {
                TheAnomalyMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

